/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.filesvr;

import com.ibm.hsc.filesvr.FsByteStream;
import com.ibm.hsc.filesvr.FsConnection;
import com.ibm.hsc.filesvr.FsException;
import com.ibm.hsc.filesvr.FsPacket;

public class FsFileReadPacket
extends FsPacket {
    protected long m_readOffset = -1L;
    protected int m_readLength = -1;
    protected int m_fileAction = -1;
    protected long m_fileHandle = -1L;
    protected int m_fileType = -1;
    protected String m_fileName = null;

    public FsFileReadPacket(FsConnection fsConnection) {
        super(fsConnection, 7);
    }

    public FsFileReadPacket(FsConnection fsConnection, long l, int n, long l2) {
        super(fsConnection, 7);
        this.setReadOffset(l);
        this.setReadLength(n);
        this.setFileAction(0);
        this.setFileHandle(l2);
    }

    public FsFileReadPacket(FsConnection fsConnection, long l, int n, int n2, long l2) {
        super(fsConnection, 7);
        this.setReadOffset(l);
        this.setReadLength(n);
        this.setFileAction(n2);
        this.setFileHandle(l2);
    }

    public FsFileReadPacket(FsConnection fsConnection, long l, int n, int n2, int n3, String string) {
        super(fsConnection, 7);
        this.setReadOffset(l);
        this.setReadLength(n);
        this.setFileAction(n2);
        this.setFileHandle(0L);
        this.setFileType(n3);
        this.setFileName(string);
    }

    public FsFileReadPacket(FsPacket fsPacket) {
        super(fsPacket, 7);
        if (fsPacket != null && fsPacket instanceof FsFileReadPacket) {
            FsFileReadPacket fsFileReadPacket = (FsFileReadPacket)fsPacket;
            this.m_readOffset = fsFileReadPacket.m_readOffset;
            this.m_readLength = fsFileReadPacket.m_readLength;
            this.m_fileAction = fsFileReadPacket.m_fileAction;
            this.m_fileHandle = fsFileReadPacket.m_fileHandle;
            this.m_fileType = fsFileReadPacket.m_fileType;
            this.m_fileName = fsFileReadPacket.m_fileName;
        }
    }

    public FsFileReadPacket(FsPacket fsPacket, long l, int n, long l2) {
        super(fsPacket, 7);
        this.setReadOffset(l);
        this.setReadLength(n);
        this.setFileAction(0);
        this.setFileHandle(l2);
    }

    public FsFileReadPacket(FsPacket fsPacket, long l, int n, int n2, long l2) {
        super(fsPacket, 7);
        this.setReadOffset(l);
        this.setReadLength(n);
        this.setFileAction(n2);
        this.setFileHandle(l2);
    }

    public FsFileReadPacket(FsPacket fsPacket, long l, int n, int n2, int n3, String string) {
        super(fsPacket, 7);
        this.setReadOffset(l);
        this.setReadLength(n);
        this.setFileAction(n2);
        this.setFileHandle(0L);
        this.setFileType(n3);
        this.setFileName(string);
    }

    public FsFileReadPacket(FsFileReadPacket fsFileReadPacket) {
        super(fsFileReadPacket);
        if (fsFileReadPacket != null) {
            this.m_readOffset = fsFileReadPacket.m_readOffset;
            this.m_readLength = fsFileReadPacket.m_readLength;
            this.m_fileAction = fsFileReadPacket.m_fileAction;
            this.m_fileHandle = fsFileReadPacket.m_fileHandle;
            this.m_fileType = fsFileReadPacket.m_fileType;
            this.m_fileName = fsFileReadPacket.m_fileName;
        }
    }

    protected void buildData(FsByteStream fsByteStream) throws FsException {
        super.buildData(fsByteStream);
        if (this.getOpCode() != 7) {
            throw new FsException(19, this.getOpCode());
        }
    }

    public long getFileAction() {
        return this.m_fileAction;
    }

    public long getFileHandle() {
        return this.m_fileHandle;
    }

    public int getReadLength() {
        return this.m_readLength;
    }

    public long getReadOffset() {
        return this.m_readOffset;
    }

    protected void parseData(FsByteStream fsByteStream) throws FsException {
        super.parseData(fsByteStream);
        if (this.getOpCode() != 7) {
            throw new FsException(19, this.getOpCode());
        }
    }

    public void setFileAction(int n) {
        this.m_fileAction = n;
    }

    public void setFileHandle(long l) {
        this.m_fileHandle = l;
    }

    public void setFileName(String string) {
        this.m_fileName = string;
        if (this.m_fileName != null && this.m_fileName.length() > 0) {
            this.m_fileHandle = 0L;
        }
    }

    public void setFileType(int n) {
        this.m_fileType = n;
        this.m_fileHandle = 0L;
    }

    public void setReadOffset(long l) {
        this.m_readOffset = l;
    }

    public void setReadLength(int n) {
        this.m_readLength = n;
    }
}

